/*
 * Decompiled with CFR 0.152.
 */
package gota.httpclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class HttpConnect {
    private Socket HttpProxyConnect(Proxy proxy, String host, int port) throws UnknownHostException, IOException, ConnectException {
        InetSocketAddress sa = (InetSocketAddress)proxy.address();
        String phost = sa.isUnresolved() ? sa.getHostName() : sa.getAddress().getHostAddress();
        int pport = sa.getPort();
        Socket proxysock = new Socket(phost, pport);
        String req = "CONNECT " + host + ":" + port + " HTTP/1.1\r\n\r\n";
        proxysock.getOutputStream().write(req.getBytes());
        BufferedReader proxyIn = new BufferedReader(new InputStreamReader(proxysock.getInputStream()));
        String line = proxyIn.readLine();
        if (!line.matches("^HTTP/\\d\\.\\d\\s200\\s.*")) {
            throw new ConnectException("Proxy response: " + line);
        }
        System.out.println("Proxy response: " + line);
        proxyIn.readLine();
        return proxysock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket Connect(URL url, Proxy proxy) throws NoSuchAlgorithmException, KeyManagementException, ConnectException, UnknownHostException, IOException {
        int port;
        boolean useProxy;
        Socket ret = null;
        String host = url.getHost();
        boolean bl = useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
        if (url.getProtocol().equals("https")) {
            int port2 = -1 == url.getPort() ? 443 : url.getPort();
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new X509TrustManager[]{new DummyTrustManager()}, null);
            if (useProxy) {
                if (proxy.type() == Proxy.Type.HTTP) {
                    System.out.println("Using SSL socket, via HTTP proxy");
                    return context.getSocketFactory().createSocket(this.HttpProxyConnect(proxy, host, port2), host, port2, true);
                }
                if (proxy.type() != Proxy.Type.SOCKS) throw new ConnectException("Unkown proxy type " + (Object)((Object)proxy.type()));
                System.out.println("Using SSL socket, via SOCKS proxy");
                Socket tsock = new Socket(proxy);
                tsock.connect(new InetSocketAddress(host, port2));
                return context.getSocketFactory().createSocket(tsock, host, port2, true);
            }
            System.out.println("Using SSL socket, direct connection");
            return context.getSocketFactory().createSocket(host, port2);
        }
        int n = port = -1 == url.getPort() ? 80 : url.getPort();
        if (useProxy) {
            if (proxy.type() == Proxy.Type.HTTP) {
                InetSocketAddress sa = (InetSocketAddress)proxy.address();
                host = sa.isUnresolved() ? sa.getHostName() : sa.getAddress().getHostAddress();
                port = sa.getPort();
                System.out.println("Using non SSL socket, proxy=" + host + ":" + port);
                return new Socket(host, port);
            }
            if (proxy.type() != Proxy.Type.SOCKS) throw new ConnectException("Unkown proxy type " + (Object)((Object)proxy.type()));
            System.out.println("Using non SSL socket, via SOCKS proxy");
            Socket tsock = new Socket(proxy);
            tsock.connect(new InetSocketAddress(host, port));
            return tsock;
        }
        System.out.println("Using non SSL socket, direct connection");
        return new Socket(host, port);
    }

    public Socket Connect(URL url) throws NoSuchAlgorithmException, KeyManagementException, ConnectException, UnknownHostException, IOException, URISyntaxException {
        Proxy proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
        return this.Connect(url, proxy);
    }

    public String getProtocol(String sUrl) throws ConnectException {
        try {
            URL url = new URL(sUrl);
            Proxy proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
            boolean useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
            boolean useSSL = url.getProtocol().equals("https");
            Socket s = this.Connect(url, proxy);
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
            StringBuffer req = new StringBuffer();
            req.append("HEAD ");
            if (useProxy && !useSSL) {
                req.append(url.getProtocol()).append("://").append(url.getHost());
            }
            req.append(url.getPath());
            req.append(" ").append("HTTP/1.1").append("\r\n");
            req.append("Host: ").append(url.getHost()).append("\r\n");
            req.append("Connection: close\r\n\r\n");
            s.getOutputStream().write(req.toString().getBytes());
            s.shutdownOutput();
            String line = in.readLine();
            s.close();
            Matcher m = Pattern.compile("^(HTTP/\\d\\.\\d)\\s.*").matcher(line);
            if (!m.matches()) {
                throw new ConnectException("HEAD response: " + line);
            }
            System.out.println("HEAD response: " + line);
            return m.group(1);
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            throw new ConnectException(e.toString());
        }
    }

    protected final class DummyTrustManager
    implements X509TrustManager {
        protected DummyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

