/*
 * Decompiled with CFR 0.152.
 */
package gota.httpclient;

import gota.Gota;
import gota.Monitor;
import gota.exception.UserCancelledException;
import gota.httpclient.HttpConnect;
import gota.httpclient.HttpInputStream;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DownloadThread
implements ActionListener {
    private DataOutputStream dataOut = null;
    private OutputStream out = null;
    private Socket sock = null;
    private HttpInputStream dataIn = null;
    private StringBuffer sbHttpResponseBody = null;
    private static final Pattern pHttpStatus = Pattern.compile("^HTTP/\\d\\.\\d\\s+((\\d+)\\s+.*)$");
    private static final Pattern pContentLength = Pattern.compile("^Content-Length:\\s+(\\w*)$", 2);
    private boolean stop = false;
    private long ContentLength = 0L;
    private long Downloaded = 0L;

    public void download(String sUrl, String localFileName) throws MalformedURLException, URISyntaxException, NoSuchAlgorithmException, IOException, KeyManagementException, UserCancelledException {
        int numRead;
        String line;
        Gota.info("Downloading " + sUrl);
        Monitor.statusDialog.addCancelListener(this);
        sUrl = sUrl.replace("&amp;", "&");
        URL url = new URL(sUrl);
        Proxy proxy = null;
        proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
        boolean useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
        boolean useSSL = url.getProtocol().equals("https");
        StringBuffer header = new StringBuffer();
        header.append("GET ");
        if (useProxy && !useSSL) {
            header.append(url.getProtocol()).append("://").append(url.getHost());
        }
        header.append(url.getPath() + "?" + url.getQuery());
        header.append(" ").append("HTTP/1.1").append("\r\n");
        header.append("Host: ").append(url.getHost()).append("\r\nAccept: */*\r\n");
        header.append("User-Agent: GOTA\r\n");
        header.append("Connection: close\r\n");
        header.append("Cookie: groupoffice=").append(Gota.sid).append("\r\n");
        header.append("\r\n");
        Monitor.statusDialog.setText(Gota.lang.getString("statusConnecting"));
        this.sock = new HttpConnect().Connect(url, proxy);
        this.dataOut = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        this.dataIn = new HttpInputStream(this.sock.getInputStream());
        this.dataOut.writeBytes(header.toString());
        this.dataOut.flush();
        boolean readingHttpBody = false;
        int status = 0;
        this.Downloaded = 0L;
        this.ContentLength = 0L;
        this.out = new BufferedOutputStream(new FileOutputStream(localFileName));
        Monitor.statusDialog.setText(Gota.lang.getString("statusDownloading"));
        byte[] buffer = new byte[1024];
        long numWritten = 0L;
        while (!this.dataIn.endOfHeader() && (line = this.dataIn.readLine()) != "") {
            Matcher mCL;
            Matcher m;
            System.out.println(line);
            if (status == 0 && (m = pHttpStatus.matcher(line)).matches()) {
                status = Integer.parseInt(m.group(2));
            }
            if (!(mCL = pContentLength.matcher(line)).matches()) continue;
            this.ContentLength = Long.parseLong(mCL.group(1));
        }
        while ((numRead = this.dataIn.read(buffer)) != -1) {
            this.Downloaded += (long)numRead;
            this.out.write(buffer, 0, numRead);
            if (this.ContentLength <= 0L) continue;
            long percent = this.Downloaded * 100L / this.ContentLength;
            int percentInt = (int)percent;
            Monitor.statusDialog.setProgress(percentInt);
        }
        this.dataIn.close();
        this.dataOut.close();
        this.out.close();
        Monitor.statusDialog.setText(Gota.lang.getString("statusDownloadComplete"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.dataIn.close();
            this.dataOut.close();
            this.out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            throw new UserCancelledException("User Cancelled");
        }
    }
}

