/*
 * Decompiled with CFR 0.152.
 */
package gota;

import gota.ActionDialog;
import gota.GOFFile;
import gota.Gota;
import gota.PasswordDialog;
import gota.StatusDialog;
import gota.exception.UserCancelledException;
import gota.httpclient.DownloadThread;
import gota.httpclient.UploadThread;
import java.awt.Desktop;
import java.awt.TrayIcon;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Monitor
extends AbstractTableModel {
    private Timer timer;
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat();
    private HashMap<String, GOFFile> monitoredFiles = new HashMap();
    private String[] columnName = new String[]{"filename", "last modified", "local filename", "url"};
    private String uploadingFile = "";
    private GOFFile justUploadedGOFFile;
    private String lockAction = "1";
    public static StatusDialog statusDialog = new StatusDialog();

    public Monitor() {
        this.trustAllCertificates();
        File monDir = new File(Gota.MONITOR_DIR);
        monDir.mkdirs();
        File tempDir = new File(Gota.TEMP_DIR);
        tempDir.mkdirs();
        this.timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    try {
                        Monitor.this.monitorFiles();
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(Monitor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        };
        this.timer.scheduleAtFixedRate(task, 0L, 4000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorGOF(String url) {
        GOFFile gofFile;
        Gota.info("Monitor GOF file: " + url);
        statusDialog.setVisible(true);
        GOFFile gOFFile = gofFile = this.getGOFFile(url);
        synchronized (gOFFile) {
            String tempGof = Gota.TEMP_DIR + "temp.gof";
            DownloadThread dl = new DownloadThread();
            try {
                dl.download(url, tempGof);
                gofFile.readProperties(tempGof);
                gofFile.setFilename(new File(gofFile.get("remote_path")).getName());
                String localFilename = Gota.TEMP_DIR + gofFile.getFilename();
                File localFile = new File(localFilename);
                Gota.info("Downloading to: " + localFilename);
                dl = new DownloadThread();
                dl.download(Gota.appendSecurityToken(gofFile.get("remote_download_url")), localFilename);
                String monitoredFilename = Gota.MONITOR_DIR + gofFile.getFilename();
                File monitoredFile = new File(monitoredFilename);
                int count = 0;
                while (monitoredFile.exists()) {
                    ++count;
                    String filename = localFile.getName();
                    String ext = "";
                    String name = filename;
                    int dotIndex = filename.lastIndexOf(46);
                    if (dotIndex > 0) {
                        ext = filename.substring(filename.lastIndexOf(46) + 1, filename.length());
                        name = filename.substring(0, filename.lastIndexOf(46));
                    }
                    monitoredFile = new File(Gota.MONITOR_DIR + name + "_" + count + "." + ext);
                }
                localFile.renameTo(monitoredFile);
                gofFile.setLocalFile(monitoredFile);
                gofFile.setFilename(monitoredFilename);
                try {
                    String askLaunch = gofFile.get("ask_launch");
                    if (askLaunch.equals("false")) {
                        this.launchDefaultApplication(gofFile);
                        this.addFile(gofFile);
                    } else {
                        String msg = Gota.lang.getString("txtChooseAction");
                        msg = MessageFormat.format(msg, monitoredFile.getName());
                        ActionDialog actionDialog = new ActionDialog(new JFrame(), Gota.lang.getString("titleActionDialog"), msg);
                        String buttonClicked = actionDialog.getButtonClicked();
                        if (buttonClicked == "launch") {
                            this.launchDefaultApplication(gofFile);
                            this.addFile(gofFile);
                        } else if (buttonClicked == "save") {
                            this.saveAs(gofFile);
                            this.addFile(gofFile);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (UserCancelledException ucE) {
                Gota.info("User cancelled");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        statusDialog.setVisible(false);
    }

    private void saveAs(GOFFile gofFile) {
        File localFile = gofFile.getLocalFile();
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(gofFile.get("remote_path")));
        int result = fc.showSaveDialog(new JFrame());
        switch (result) {
            case 0: {
                File selectedFile = fc.getSelectedFile();
                if (selectedFile.exists()) {
                    String title;
                    String msg = Gota.lang.getString("txtFileExists");
                    int option = JOptionPane.showConfirmDialog(null, msg = MessageFormat.format(msg, selectedFile.getName()), title = fc.getDialogTitle(), 0, 2);
                    if (option == 1) {
                        this.saveAs(gofFile);
                        return;
                    }
                }
                localFile.renameTo(selectedFile);
                gofFile.setLocalFile(selectedFile);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void setLockParams(GOFFile gofFile, String lockAction) {
        this.justUploadedGOFFile = gofFile;
        this.lockAction = lockAction;
        if ("0".equals(lockAction)) {
            String msg = Gota.lang.getString("txtFileSent");
            msg = MessageFormat.format(msg, this.justUploadedGOFFile.getName());
            Gota.trayIcon.displayMessage(Gota.lang.getString("txtUploadSuccess"), msg, TrayIcon.MessageType.INFO);
        } else {
            String msg = Gota.lang.getString("txtClickLockFile");
            msg = MessageFormat.format(msg, this.justUploadedGOFFile.getName());
            Gota.trayIcon.displayMessage(Gota.lang.getString("txtLockFile"), msg, TrayIcon.MessageType.INFO);
        }
    }

    private void launchDefaultApplication(GOFFile gofFile) throws IOException {
        this.setLockParams(gofFile, "1");
        Gota.info("Launching: " + gofFile.getLocalFile());
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0 || os.indexOf("mac") >= 0) {
            Gota.info("Using desktop.open to launch default application");
            Desktop desktop = Desktop.getDesktop();
            desktop.open(gofFile.getLocalFile());
        } else {
            String launcher = "";
            launcher = "run-mailcap";
            File xdgOpen = new File("/usr/bin/xdg-open");
            File gnomeOpen = new File("/usr/bin/gnome-open");
            File kdeOpen = new File("/usr/bin/kde-open");
            if (xdgOpen.canExecute()) {
                launcher = "xdg-open";
            } else if (gnomeOpen.canExecute()) {
                launcher = "gnome-open";
            } else if (kdeOpen.canExecute()) {
                launcher = "kde-open";
            }
            String[] cmds = new String[]{launcher, gofFile.getLocalFile().getAbsolutePath()};
            Gota.info("Running: " + cmds[0] + " " + cmds[1]);
            Runtime rt = Runtime.getRuntime();
            gofFile.setProcess(rt.exec(cmds));
        }
    }

    public GOFFile getGOFFile(String url) {
        GOFFile file = this.monitoredFiles.get(url);
        if (file == null) {
            file = new GOFFile(url);
        }
        return file;
    }

    public void addFile(GOFFile file) {
        file.put("last_modified", String.valueOf(file.lastModified()));
        file.setOwner(this);
        this.monitoredFiles.put(file.getUrl(), file);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void removeFile(String url) {
        this.monitoredFiles.remove(url);
        this.fireTableChanged(new TableModelEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorFiles() throws UnsupportedEncodingException, MalformedURLException {
        for (String url : this.monitoredFiles.keySet()) {
            GOFFile file = this.monitoredFiles.get(url);
            if (!file.isModified()) continue;
            GOFFile gOFFile = file;
            synchronized (gOFFile) {
                Gota.info("Uploading modified file " + file.getName());
                file.setBusy(true);
                this.uploadingFile = file.getName();
                File[] files = new File[]{file.getLocalFile()};
                String remoteProcessUrl = file.get("remote_process_url") + "&id=" + URLEncoder.encode(file.get("remote_id"), "UTF-8") + "&ajax=1&security_token=" + Gota.securityToken;
                UploadThread upload = new UploadThread(files, remoteProcessUrl);
                HashMap<String, String> postVariables = new HashMap<String, String>();
                try {
                    int status = 0;
                    for (int i = 0; i < 3; ++i) {
                        upload.setPostVariables(postVariables);
                        status = upload.sendFiles();
                        Gota.info("Upload status: " + status);
                        if (status == 200) break;
                        if (status != 403) {
                            JOptionPane.showMessageDialog(new JFrame(), upload.feedback, Gota.lang.getString("txtError"), 2);
                            break;
                        }
                        PasswordDialog pd = new PasswordDialog(new JFrame(), Gota.lang.getString("txtAuthorizationRequired"), "message", file.get("remote_base_url"), file.get("username"));
                        if (pd.buttonClicked == "CANCEL") {
                            throw new UserCancelledException();
                        }
                        postVariables.put("security_token", Gota.securityToken);
                    }
                    if (status == 200) {
                        if (upload.success) {
                            this.setLockParams(file, "0");
                        } else {
                            Gota.trayIcon.displayMessage(Gota.lang.getString("txtError"), Gota.lang.getString("txtUploadError"), TrayIcon.MessageType.ERROR);
                            JOptionPane.showMessageDialog(new JFrame(), upload.feedback, Gota.lang.getString("txtError"), 2);
                        }
                    } else {
                        JOptionPane.showMessageDialog(new JFrame(), Gota.lang.getString("txtUploadError"), Gota.lang.getString("txtError"), 2);
                    }
                }
                catch (UserCancelledException e) {
                    Gota.info("User cancelled");
                }
                file.setBusy(false);
                file.updateModified();
                this.uploadingFile = "";
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Group-Office Transfer Agent 0.1 - Copyright Intermesh 2007\nmonitor");
        Iterator<String> it = this.monitoredFiles.keySet().iterator();
        while (it.hasNext()) {
            sb.append("\n");
            sb.append(this.monitoredFiles.get(it.next()).toString());
        }
        return sb.toString();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Iterator<String> it = this.monitoredFiles.keySet().iterator();
        int column = columnIndex;
        String key = it.next();
        for (int row = 0; row < rowIndex; ++row) {
            if (!it.hasNext()) continue;
            key = it.next();
        }
        GOFFile f = this.monitoredFiles.get(key);
        if (column == 0) {
            return f.getName();
        }
        if (column == 1) {
            return dateFormat.format(new Date(f.lastModified()));
        }
        if (column == 2) {
            return f.getPath();
        }
        return f.getUrl();
    }

    @Override
    public int getRowCount() {
        return this.monitoredFiles.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnName[column];
    }

    private void trustAllCertificates() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void lockFile() {
        Gota.info("Locking in file: " + this.lockAction);
        if (this.justUploadedGOFFile != null) {
            try {
                String line;
                String data = "id=" + this.justUploadedGOFFile.get("remote_id");
                data = data + "&lock=" + this.lockAction;
                HostnameVerifier hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
                URL url = new URL(Gota.appendSecurityToken(this.justUploadedGOFFile.get("remote_submit_url")));
                URLConnection conn = url.openConnection();
                conn.setRequestProperty("Cookie", "groupoffice=" + Gota.sid);
                conn.setRequestProperty("X-Requested-With", "XMLHttpRequest");
                System.out.println(conn.getRequestProperties());
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(data);
                wr.flush();
                StringBuilder response = new StringBuilder();
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = rd.readLine()) != null) {
                    response.append(line);
                }
                Gota.info(response.toString());
                Object obj = JSONValue.parse(response.toString());
                JSONObject jsonObj = (JSONObject)obj;
                Boolean success = (Boolean)jsonObj.get("success");
                if (success.booleanValue()) {
                    String msg = "0".equals(this.lockAction) ? Gota.lang.getString("txtUnlockSuccess") : Gota.lang.getString("txtLockSuccess");
                    msg = MessageFormat.format(msg, this.justUploadedGOFFile.getName());
                    Gota.trayIcon.displayMessage(Gota.lang.getString("txtSuccess"), msg, TrayIcon.MessageType.INFO);
                } else {
                    Gota.trayIcon.displayMessage(Gota.lang.getString("txtError"), (String)jsonObj.get("feedback"), TrayIcon.MessageType.ERROR);
                }
                wr.close();
                rd.close();
            }
            catch (Exception e) {
                Gota.error("Exception in checking process");
                Gota.error(e.getMessage());
                e.printStackTrace();
            }
        } else {
            Gota.error("just uploaded file was not set");
        }
    }
}

