/*
 * Decompiled with CFR 0.152.
 */
package gota.httpclient;

import gota.Gota;
import gota.StatusDialog;
import gota.exception.UserCancelledException;
import gota.httpclient.HttpConnect;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class UploadThread
extends Thread {
    private static final Pattern pHttpStatus = Pattern.compile("^HTTP/\\d\\.\\d\\s+((\\d+)\\s+.*)$");
    private File[] files;
    private String uploadURL;
    private long totalFilesLength;
    private long uploadedLength;
    private boolean stop = false;
    private StringBuffer sb = new StringBuffer();
    private Exception e = null;
    private HashMap PostVariables;
    private StatusDialog StatusDialog = new StatusDialog();
    public String responseBody;
    public String responseHeader;
    public boolean success = false;
    public String feedback = "";

    public UploadThread(File[] files, String uploadURL) {
        this.files = files;
        this.uploadURL = uploadURL;
        this.totalFilesLength = 0L;
        for (int i = 0; i < this.files.length; ++i) {
            this.totalFilesLength += this.files[i].length();
        }
    }

    public long getUploadedLength() {
        return this.uploadedLength;
    }

    public long getTotalLength() {
        return this.totalFilesLength;
    }

    public void stopUpload() {
        this.stop = true;
    }

    public StringBuffer getServerOutput() {
        return this.sb;
    }

    public Exception getException() {
        return this.e;
    }

    private StringBuffer getRandomString() {
        StringBuffer sbRan = new StringBuffer(11);
        StringBuffer alphaNum = new StringBuffer();
        alphaNum.append("1234567890abcdefghijklmnopqrstuvwxyz");
        for (int i = 0; i < 11; ++i) {
            int num = (int)(Math.random() * (double)(alphaNum.length() - 1));
            sbRan.append(alphaNum.charAt(num));
        }
        return sbRan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFileStream(File f, DataOutputStream dOut) throws FileNotFoundException, IOException {
        byte[] byteBuff = null;
        FileInputStream fis = null;
        try {
            int numBytes = 0;
            byteBuff = new byte[1024];
            fis = new FileInputStream(f);
            System.out.println(fis.toString());
            while (-1 != (numBytes = fis.read(byteBuff)) && !this.stop) {
                if (this.StatusDialog.CancelClicked) {
                    return;
                }
                dOut.write(byteBuff, 0, numBytes);
                this.uploadedLength += (long)numBytes;
                long percent = this.uploadedLength * 100L / this.totalFilesLength;
                int percentInt = (int)percent;
                this.StatusDialog.setProgress(percentInt);
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
            byteBuff = null;
        }
    }

    private void addServerOutPut(String s) {
        if (0 < this.sb.length() || !s.equals("")) {
            this.sb.append(s);
        }
    }

    private StringBuffer[] setAllHead(File[] fileA, StringBuffer bound) {
        StringBuffer[] sbArray = new StringBuffer[fileA.length];
        for (int i = 0; i < fileA.length; ++i) {
            File file = fileA[i];
            sbArray[i] = new StringBuffer();
            StringBuffer sb = sbArray[i];
            sb.append(bound.toString());
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data; name=\"File");
            sb.append(i);
            String filename = file.toString();
            sb.append("\"; filename=\"");
            sb.append(filename);
            sb.append("\"");
            sb.append("\r\n");
            sb.append("Content-Type: application/octet-stream");
            sb.append("\r\n");
            sb.append("Cookie: groupoffice=").append(Gota.sid).append("\r\n");
            sb.append("\r\n");
        }
        return sbArray;
    }

    private StringBuffer[] setAllTail(int fileLength, StringBuffer bound) {
        StringBuffer[] sbArray = new StringBuffer[fileLength];
        for (int i = 0; i < fileLength; ++i) {
            sbArray[i] = new StringBuffer("\r\n");
        }
        sbArray[sbArray.length - 1].append(bound.toString());
        sbArray[sbArray.length - 1].append("--\r\n");
        return sbArray;
    }

    private StringBuffer addPostVariable(String boundary, String name, String value) {
        StringBuffer sb = new StringBuffer();
        return sb.append(boundary).append("\r\n").append("Content-Disposition: form-data; name=\"").append(name).append("\"\r\nContent-Transfer-Encoding: 8bit\r\n\r\n").append(value).append("\r\n");
    }

    public void setPostVariables(HashMap PostVariables) {
        this.PostVariables = PostVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendFiles() throws UserCancelledException {
        Socket sock = null;
        FilterOutputStream dataout = null;
        BufferedReader datain = null;
        int status = 0;
        this.StatusDialog.setVisible(true);
        try {
            String line;
            URL url = new URL(this.uploadURL);
            System.out.println("Sending file to " + this.uploadURL);
            StringBuffer boundary = new StringBuffer();
            boundary.append("-----------------------------");
            boundary.append(this.getRandomString().toString());
            long contentLength = this.totalFilesLength;
            StringBuffer[] head = this.setAllHead(this.files, boundary);
            StringBuffer[] tail = this.setAllTail(this.files.length, boundary);
            for (int i = 0; i < this.files.length; ++i) {
                contentLength += (long)head[i].length();
                contentLength += (long)tail[i].length();
            }
            Set keys = this.PostVariables.keySet();
            Iterator keyIter = keys.iterator();
            StringBuffer params = new StringBuffer();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                params.append(this.addPostVariable(boundary.toString(), key, (String)this.PostVariables.get(key)));
            }
            contentLength += (long)params.length();
            StringBuffer header = new StringBuffer();
            header.append("POST ");
            header.append(url.getPath() + "?" + url.getQuery());
            header.append(" HTTP/1.0\r\n");
            header.append("Host: ");
            header.append(url.getHost());
            header.append("\r\n");
            header.append("Cookie: groupoffice=").append(Gota.sid).append("\r\n");
            header.append("Content-type: multipart/form-data; boundary=");
            header.append(boundary.substring(2, boundary.length()) + "\r\n");
            header.append("Connection: close\r\n");
            header.append("Content-length: ");
            header.append(contentLength - 2L);
            header.append("\r\n");
            header.append("\r\n");
            header.append(params);
            Gota.info(header.toString());
            Proxy proxy = null;
            proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
            boolean useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
            boolean useSSL = url.getProtocol().equals("https");
            this.StatusDialog.setText(Gota.lang.getString("statusConnecting"));
            sock = new HttpConnect().Connect(url, proxy);
            dataout = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
            datain = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            this.uploadedLength = 0L;
            this.StatusDialog.setText(Gota.lang.getString("statusUploading"));
            ((DataOutputStream)dataout).writeBytes(header.toString());
            for (int i = 0; i < this.files.length && !this.stop; ++i) {
                ((DataOutputStream)dataout).writeBytes(head[i].toString());
                this.uploadFileStream(this.files[i], (DataOutputStream)dataout);
                if (this.StatusDialog.CancelClicked) {
                    throw new UserCancelledException("User cancelled");
                }
                ((DataOutputStream)dataout).writeBytes(tail[i].toString());
            }
            ((DataOutputStream)dataout).flush();
            if (!this.stop) {
                System.out.println("File(s) uploaded. Wait for server response!");
            }
            this.StatusDialog.setText(Gota.lang.getString("statusUploadComplete"));
            boolean inHeader = true;
            this.responseBody = "";
            this.responseHeader = "";
            while ((line = datain.readLine()) != null && !this.stop) {
                Matcher m;
                if (inHeader) {
                    this.responseHeader = this.responseHeader + line + "\n";
                } else {
                    this.responseBody = this.responseBody + line + "\n";
                }
                if (line.compareTo("") == 0) {
                    inHeader = false;
                }
                if (status == 0 && (m = pHttpStatus.matcher(line)).matches()) {
                    status = Integer.parseInt(m.group(2));
                }
                Gota.info(line);
            }
            Object obj = JSONValue.parse(this.responseBody.toString());
            JSONObject jsonObj = (JSONObject)obj;
            this.success = (Boolean)jsonObj.get("success");
            if (!this.success) {
                status = "GO\\Base\\Exception\\AccessDenied".equals((String)jsonObj.get("exceptionClass")) ? 403 : 500;
                this.feedback = (String)jsonObj.get("feedback");
            }
        }
        catch (UserCancelledException ucE) {
            throw new UserCancelledException("User cancelled");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                dataout.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dataout = null;
            try {
                datain.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            datain = null;
            try {
                sock.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sock = null;
            this.StatusDialog.setVisible(false);
        }
        return status;
    }

    public void close() {
        this.files = null;
        this.e = null;
        this.sb = null;
    }
}

