lse ) {
	if ( ( ( ! basel_get_opt( 'lazy_loading' ) || is_admin() ) && ! $force_init ) ) {
		return;
	}

	// Used for product categories images for example.
	add_filter('basel_attachment', 'basel_lazy_attachment_replace', 10, 3);

	// Used for instagram images.
	add_filter('basel_image', 'basel_lazy_image_standard', 10, 1);

	// Used for avatar images.
	add_filter( 'get_avatar', 'basel_lazy_avatar_image', 10 );

	// Images generated by WPBakery functions
	add_filter('vc_wpb_getimagesize', 'basel_lazy_image', 10, 3);

	// Products, blog, a lot of other standard wordpress images
	add_filter('wp_get_attachment_image_attributes', 'basel_lazy_attributes', 10, 3);

}

add_action( 'init', 'basel_lazy_loading_init', 120 );

function basel_lazy_loading_deinit( $force_deinit = false ) {
	if ( basel_get_opt( 'lazy_loading' ) && ! $force_deinit ) {
		return;
	}

	remove_action( 'basel_attachment', 'basel_lazy_attachment_replace', 10, 3) ;
	remove_action( 'get_avatar', 'basel_lazy_avatar_image', 10 );
	remove_action( 'basel_image', 'basel_lazy_image_standard', 10, 1 );
	remove_action( 'vc_wpb_getimagesize', 'basel_lazy_image', 10, 3 );
	remove_action( 'wp_get_attachment_image_attributes', 'basel_lazy_attributes', 10, 3 );
}

/**
 * Fix Woocommerce email with lazy load
 */
if ( ! function_exists( 'basel_stop_lazy_loading_before_order_table' ) ) {
	function basel_stop_lazy_loading_before_order_table() {
		basel_lazy_loading_deinit( true );
	}

	add_action( 'woocommerce_email_before_order_table', 'basel_stop_lazy_loading_before_order_table', 20 );
}


if ( ! function_exists( 'basel_start_lazy_loading_before_order_table' ) ) {
	function basel_start_lazy_loading_before_order_table() {
		basel_lazy_loading_init( true );
	}

	add_action( 'woocommerce_email_after_order_table', 'basel_start_lazy_loading_before_order_table', 20 );
}

/**
 * ------------------------------------------------------------------------------------------------
 * Get script URL
 * ------------------------------------------------------------------------------------------------
 */
if( ! function_exists( 'basel_get_script_url') ) {
	function basel_get_script_url( $script_name ) {
	    return BASEL_SCRIPTS . '/' . $script_name . '.min.js';
	}
}
